// TRG-Pro Compact-flash FAT library

#define O_RDONLY       0x0000   /* Open for read only                       */
#define O_WRONLY       0x0001   /* Open for write only                      */
#define O_RDWR         0x0002   /* Read/write access allowed.               */
#define O_APPEND       0x0008   /* Seek to eof on each write                */
#define O_CREAT        0x0100   /* Create the file if it does not exist.    */
#define O_BINARY       0x8000   /* Ignored. All file access is binary       */

#define S_IREAD    0000200    /* Read permitted. (Always true anyway)   */
#define S_IWRITE   0000400    /* Write permitted                        */

#define SEEK_SET   0  /* offset from begining of file        */
#define SEEK_CUR   1  /* offset from current file pointer    */
#define SEEK_END   2  /* offset from end of file             */

#define FA_NORMAL     0x00      /* "normal" file                            */
#define FA_RDONLY     0x01      /* read only                                */
#define FA_HIDDEN     0x02      /* hidden file                              */
#define FA_SYSTEM     0x04      /* system file                              */
#define FA_LABEL      0x08      /* disk volume label                        */
#define FA_DIREC      0x10      /* subdirectory                             */
#define FA_ARCH       0x20      /* archive                                  */
#define FA_ALL        0x8000    /* matches anything for FfsFindfirst()      */

typedef struct {
    char    ff_reserved[21];   /* used by system -- don't modify!         */
    char    ff_attrib;         /* DOS file attributes                     */
    Int     ff_ftime;          /* creation time                           */
    Int     ff_fdate;          /* creation date                           */
    long    ff_fsize;          /* file size                               */
    char    ff_name[13];       /* name in 8.3 format                      */
    char    ff_longname[256];  /* long file name                          */
} ffblk;

typedef struct {
    UInt32  avail_clusters;       /* number of free clusters              */
    UInt32  total_clusters;       /* total number of clusters on drive    */
    UInt16  bytes_per_sector;     /* number bytes per sector              */
    UInt16  sectors_per_cluster;  /* number sectors per cluster           */
} diskfree_t;

typedef enum {
    FfsLibTrapGetLibAPIVersion = sysLibTrapCustom,
    FfsLibTrapGetdiskfree,
    FfsLibTrapFindfirst,
    FfsLibTrapFindnext,
    FfsLibTrapFinddone,
    FfsLibTrapFileOpen,
    FfsLibTrapFileClose,
    FfsLibTrapRead,
    FfsLibTrapWrite,
    FfsLibTrapRemove,
    FfsLibTrapChdir,
    FfsLibTrapGetcwd,
    FfsLibTrapMkdir,
    FfsLibTrapRmdir,
    FfsLibTrapFormat,
    FfsLibTrapRename,
    FfsLibTrapGetfileattr,
    FfsLibTrapFlush,
    FfsLibTrapFlushDisk,
    FfsLibTrapSetfileattr,
    FfsLibTrapStat,
    FfsLibTrapFstat,
    FfsLibTrapIsDir,
    FfsLibTrapLseek,
    FfsLibTrapGetErrno,
    FfsLibTrapTell,
    FfsLibTrapGetdrive,
    FfsLibTrapSetdrive,
    FfsLibTrapUnlink,
    FfsLibTrapEof,
    FfsLibTrapCreat,
    FfsLibTrapInstErrHandle,
    FfsLibTrapUnInstErrHandle,
    FfsLibTrapSetDebuggingOn,
    FfsLibTrapSetDebuggingOff,
    FfsLibTrapCardIsInserted,
    FfsLibTrapExerciseFAT,
    FfsLibTrapCardIsATA,
    FfsLibTrapLast
} FfsLibTrapNumberEnum;
 
extern Err FfsLibOpen(UInt libRef) SYS_TRAP(sysLibTrapOpen);
extern Err FfsLibClose(UInt libRef) SYS_TRAP(sysLibTrapClose);
extern int FfsOpen(UInt libRef, char *path, int flags, int mode) SYS_TRAP(FfsLibTrapFileOpen);
extern Err FfsClose(UInt libRef, int handle) SYS_TRAP(FfsLibTrapFileClose);
extern int FfsRead(UInt libRef, int handle, void *buffer, int num_bytes) SYS_TRAP(FfsLibTrapRead);
extern int FfsWrite(UInt libRef, int handle, void *buffer, int num_bytes) SYS_TRAP(FfsLibTrapWrite);
extern Err FfsRemove(UInt libRef, char *path) SYS_TRAP(FfsLibTrapRemove);
extern Err FfsEof(UInt libRef, int handle) SYS_TRAP(FfsLibTrapEof);
extern int FfsCreat(UInt libRef, char *path, int mode) SYS_TRAP(FfsLibTrapCreat);
extern Boolean FfsCardIsInserted(UInt libRef, unsigned char drive_num) SYS_TRAP(FfsLibTrapCardIsInserted);
extern Err FfsRename(UInt libRef, char *path, char *new_name) SYS_TRAP(FfsLibTrapRename);
extern DWord FfsLseek(UInt libRef, Int handle, DWord offset, Int origin) SYS_TRAP(FfsLibTrapLseek);
extern DWord FfsTell(UInt libRef, Int handle) SYS_TRAP(FfsLibTrapTell);
extern Err FfsFindfirst(UInt libRef, char *path, Int attrib, ffblk *ff_blk) SYS_TRAP(FfsLibTrapFindfirst);
extern Err FfsFindnext(UInt libRef, ffblk *ff_blk) SYS_TRAP(FfsLibTrapFindnext);
extern Err FfsFinddone(UInt libRef, ffblk *ff_blk) SYS_TRAP(FfsLibTrapFinddone);
extern Err FfsChdir(UInt libRef, char *path) SYS_TRAP(FfsLibTrapChdir);
extern Err FfsGetcwd(UInt libRef, char *buf, int buflen) SYS_TRAP(FfsLibTrapGetcwd);
extern Err FfsGetdiskfree(UInt16 libRef, UInt8 drive, diskfree_t *dtable)
SYS_TRAP(FfsLibTrapGetdiskfree);
extern Err FfsMkdir(UInt16 libRef, char *dirname)
SYS_TRAP(FfsLibTrapMkdir);
extern Err FfsRmdir(UInt16 libRef, char *dirname)
SYS_TRAP(FfsLibTrapRmdir);
